/****************
 * BRAIN TEASER *
 ****************/

#include <stdio.h>
#include "braintsr.h"
#include "screen.h"

WORD values[] = { 
    0x01B0, // 1 = 110110000
    0x01C0, // 2 = 111000000
    0x00D8, // 3 = 011011000
    0x0124, // 4 = 100100100
    0x00BA, // 5 = 010111010
    0x0049, // 6 = 001001001
    0x0036, // 7 = 000110110
    0x0007, // 8 = 000000111
    0x001B  // 9 = 000011011
};

WORD rnd;

/*
 * Initialises the random number generator.
 */
void random(void) {
    rnd = *((WORD*) 16436); // FRAMES Systemvariable
}

/*
 * Gets a random number.
 */
WORD rndnr(void) {
    rnd = rnd * 31421 + 5972;
    return rnd;
}

/*
 * Converts a 9 bit value into a printable form.
 */
void getDual(unsigned int no, unsigned char* buf) {
    int i;
    
    buf += 8;
    
    for (i = 0; i < 9; i++) {
        if (no & 0x0001) {
            *buf = '1';
        }
        else {
            *buf = '0';
        }
        buf--;
        no >>= 1;
    }
}

/*
 * Prints the matrix.
 */
void printMatrix(WORD matrix) {
    unsigned int i, j;
    unsigned char key;
    unsigned char disp[9];
    unsigned char *p;
    
    getDual(matrix, disp);
    
    p = disp;
    key = '1';
    
    for (i = 2; i < 5; i++) {
        txtSetCursor(i, 4);
        printf("%c %c %c     %c %c %c", *p++, *p++, *p++, key++, key++, key++);
    }
}

/*
 * Prints the game instructions.
 */
void printManual(void) {
    unsigned char row;
    
    row = 0;
    txtBoldOn();
    printStringAt(row++, 2, "*** Brain Teaser  ***");
    txtBoldOff();
    printStringAt(row++, 1, "1 1 1    0 0 0    1 2 3");
    printStringAt(row++, 1, "1 0 1    0 0 0    4 5 6");
    printStringAt(row++, 1, "1 1 1    0 0 0    7 8 9");
    txtBoldOn();
    printStringAt(row++, 2, "Win      Lose   Numbers");
    txtBoldOff();
    printStringAt(row++, 0, "Turn the coins to get at");
    printStringAt(row++, 0, "the arrangement shown at");
    printStringAt(row,   0, "the left.");
    row=0;
    printStringAt(row++, 27, "At the right you see the");
    printStringAt(row++, 27, "number assignment.");
    printStringAt(row++, 27, "Avoid the arrangement in");
    printStringAt(row++, 27, "the middle.");
    txtBoldOn();
    printStringAt(row++, 28, " Input    coins turned");
    txtBoldOff();
    printStringAt(row++, 31, "1        1, 2, 4, 5");
    printStringAt(row++, 31, "2           1, 2, 3");
    printStringAt(row,   31, "3        2, 3, 5, 6");
    row=0;
//                            01234567890123456789012345
    txtBoldOn();
    printStringAt(row++, 55, "Input    coins turned");
    txtBoldOff();
    printStringAt(row++, 57, "4           1, 4, 7");
    printStringAt(row++, 57, "5        2, 4, 5, 6, 8");
    printStringAt(row++, 57, "6           3, 6, 9");
    printStringAt(row++, 57, "7        4, 5, 7, 8");
    printStringAt(row++, 57, "8           7, 8, 9");
    printStringAt(row++, 57, "9        5, 6, 8, 9");
    printStringAt(row,   56, "Start: press any key");
}

/*
 * Prints victory message.
 */
void printGewonnen(unsigned int anzahlVersuche) {
    printStringAt(6, 0, "*** YOU WIN! ***");
    txtSetCursor(7, 0);
    printf("ATTEMPTS: %d", anzahlVersuche);
}

/*
 * Prints the defeat message.
 */
void printVerloren(void) {
    printStringAt(6, 0, "*** SORRY, YOU LOSE ***");
}

/*
 * Main program.
 */
int main(void)
{
    WORD matrix;
    char input;
    unsigned int versuche;
    
    random();
    
    printManual();
    getchar();
    
    do {
        versuche = 1;
        matrix = rndnr() & MASKE;
        
        cls();
        printStringAt(0, 0, "Input: 1-9   Quit:  Q");
        printMatrix(matrix);
        
        do {
            input = getchar();
            
            if (input >= '1' && input <= '9') {
                txtSetCursor(3, 30);
                printf("Attempt %d: %c", versuche, input);
                
                matrix ^= values[input - '1'];
                
                printMatrix(matrix);
                
                if (matrix == GEWONNEN) {
                    printGewonnen(versuche);
                    break;
                }
                else if (matrix == VERLOREN) {
                    printVerloren();
                    break;
                }
                
                versuche++;
            }
        } while (input != 'Q');
        
        printStringAt(7, 30, "Play again? (Y/N) ");
        input = getchar();
    } while (input != 'N');
    
    printStringAt(7, 30, "Good bye.          ");
    getchar();
    
    return 0;
}
