/* This is file TEXT.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <conio.h>

#include "vgr.h"

#define FONTMAGIC(font)		((font)[0])
#define FONTWIDTH(font)		((font)[2])
#define FONTHEIGHT(font)	((font)[4])
#define FONTBLOCK(font)		((font)[6])
#define HEADERSIZE		8

#define CHARWIDTH(font)		(TextMx*(font)[2])
#define CHARHEIGHT(font)	(TextMy*(font)[4])
#define BLOCHEIGHT(font)	(TextMy*(font)[6])

#ifndef FONTFILE
#define FONTFILE	"c:\\font\\vga\\8x14.fnt"
#endif
#define GRSTACKSIZE	16

struct _GrStack {
	int	x;
	int	y;
	int	xl;
	int	yl;
	int	xh;
	int	yh;
	int	fg;
	int	bg;
	int	mx;
	int	my;
	int	scroll;
	int	cursor;
};

static uchar	far _GrCursorDef[] = {
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static int	TextX = 0, TextY = 0, TextFg = 1, TextBg = -1;
static int	TextMx = 1, TextMy = 1, _GrScroll = 0, _GrCursorMode = 0;
static int	TextXl = 0, TextXh = 0, TextYl = 0, TextYh = 0;
static int	TextXm = 0, TextYm = 0;
static uchar	*Font = 0, far *_GrCursor = _GrCursorDef;
static char	FontName[128] = FONTFILE;
static struct _GrStack _GrStack[GRSTACKSIZE];
static int	_GrStackP;

static void far _GrTextChar (int ch);

static void far
_GrTextSetMax (void)
{
	TextXm = TextXl
		+ ((TextXh - TextXl) / FONTWIDTH(Font)-1) * FONTWIDTH(Font);
	TextYm = TextYl
		+ ((TextYh - TextYl) / BLOCHEIGHT(Font)-1) * BLOCHEIGHT(Font);
}

static uchar * far
_GrFontLoad ()
{
	FILE	*fin;
	uchar	header[HEADERSIZE], *font;
	uint	size;

	fin = fopen (FontName, "rb");
	if (fin == 0)
		goto badret1;
	fread (header, HEADERSIZE, 1, fin);
	if (ferror (fin))
		goto badret;
	size = FONTHEIGHT(header) * 256;
	font = (uchar *)malloc (size+HEADERSIZE);
	if (font == 0)
		goto badret;
	memcpy (font, header, HEADERSIZE);
	fread (font+HEADERSIZE, size, 1, fin);
	if (ferror (fin)) {
		free (font);
		font = 0;
		goto badret;
	}
	fclose (fin);
	goto ret;
badret:
	fclose (fin);
badret1:
	size = 256*8;
	font = (uchar *)malloc (size+HEADERSIZE);
	if (font == 0)
		exit (4);
	memset (font, 0, size+HEADERSIZE);
	FONTMAGIC(font) = 0xaa;
	FONTMAGIC(font+1) = 0x55;
	FONTWIDTH(font) = 8;
	FONTHEIGHT(font) = 8;
	FONTBLOCK(font) = 8;
ret:
	return (font);
}

static void far
_GrInitXY ()
{
	int	cursave;

	cursave = GrCursorMode (0);
	TextXl = 0;
	TextXh = GrSizeX ();
	TextYl = 0;
	TextYh = GrSizeY ();
	(void)GrCursorMode (cursave);
}

static void far
_GrInit ()
{
	Font = _GrFontLoad ();
	if (TextXl >= TextXh ||
	    TextYl >= TextYh)
		_GrInitXY ();
	_GrTextSetMax ();
}

static void far
_GrFixXY0 ()
{
	if (Font == 0)
		_GrInit ();

	if (TextX > TextXm) {
		TextX = TextXl;
		TextY += BLOCHEIGHT(Font);
	} else if (TextX < TextXl) {
		TextX = TextXm;
		TextY -= BLOCHEIGHT(Font);
	}
	if (TextY > TextYm)
		if (_GrScroll) {
			GrScroll (BLOCHEIGHT(Font));
			TextY = TextYm;
		} else
			TextY = TextYl;
	else if (TextY < TextYl)
		if (_GrScroll) {
			GrScroll (-BLOCHEIGHT(Font));
			TextY = TextYl;
		} else
			TextY = TextYm;
}

static void far
_GrFixXY1 ()
{
	if (Font == 0)
		_GrInit ();

	if (TextX >= TextXh) {
		TextX = TextXl;
		TextY += BLOCHEIGHT(Font);
	} else if (TextX < TextXl) {
		TextX = TextXm;
		TextY -= BLOCHEIGHT(Font);
	}
	if (TextY >= TextYh) {
		if (_GrScroll) {
			GrScroll (BLOCHEIGHT(Font));
			TextY = TextYm;
		} else
			TextY = TextYl;
	} else if (TextY < TextYl) {
		if (_GrScroll) {
			GrScroll (-BLOCHEIGHT(Font));
			TextY = TextYl;
		} else
			TextY = TextYm;
	}
}


static void far
_GrTextChar (ch)
int	ch;
{
	int		r, c, bit, bits, m, mx, my, fx, bx, fo, bo;
	uchar		*fp, *rp;
	static uchar	row[4*4*8*16];

	_GrFixXY0 ();

	r = HEADERSIZE + FONTHEIGHT(Font) * (uchar)ch;
	fp = Font + r;

	fx = TextFg & GrXOR;
	bx = TextBg & GrXOR;
	fo = TextFg & GrOR;
	bo = TextBg & GrOR;
	if (fx || bx || TextFg == -1 || TextBg == -1)
		GrMemGet (row, TextX, TextY, CHARWIDTH(Font),
			CHARHEIGHT(Font));
	else
		memset (row, TextBg, CHARHEIGHT(Font)*CHARWIDTH(Font));

	rp = row;
	for (r = 0; r < FONTHEIGHT(Font); ++r) {
	    bits = *fp++;
	    for (my = 0; my < TextMy; ++my)
		for (c = 0, m = 0x0080; c < FONTWIDTH(Font); ++c, m >>= 1) {
		    bit = bits & m;
		    for (mx = 0; mx < TextMx; ++mx)
			if (bit) {
				if (TextFg != -1) {
					if (fx)
						*rp++ ^= TextFg;
					else if (fo)
						*rp++ |= TextFg;
					else
						*rp++  = TextFg;
				}
			} else {
				if (TextBg != -1) {
					if (bx)
						*rp++ ^= TextBg;
					else if (bo)
						*rp++ |= TextBg;
					else
						++rp;
				}
			}
		}
	}
	if (TextBg != -1 && bx)
	while (r++ < FONTBLOCK(Font)) {
		for (c = 0; c < FONTWIDTH(Font); ++c)
		  for (mx = 0; mx < TextMx; ++mx)
		    for (my = 0; my < TextMy; ++my)
			*rp++ ^= TextBg;
	}
	GrMemPut (TextX, TextY, CHARWIDTH(Font), CHARHEIGHT(Font), row);
	TextX += CHARWIDTH(Font);
	_GrFixXY1 ();
}

static void far
_GrTextCharOld (ch)
int	ch;
{
	int		r, c, bits, mx, my;
	uchar		*fp;

	_GrFixXY0 ();
	fp = Font + HEADERSIZE + FONTHEIGHT(Font) * (uchar)ch;

	for (r = 0; r < FONTHEIGHT(Font); ++r) {
		bits = *fp++;
		for (c = 0; c < FONTWIDTH(Font); ++c)
		  for (mx = 0; mx < TextMx; ++mx)
		    for (my = 0; my < TextMy; ++my)
			if (bits & (0x0080 >> c)) {
				if (TextFg != -1)
					GrPlot (TextX+c*TextMx+mx,
						TextY+r*TextMy+my, TextFg);
			} else {
				if (TextBg != -1)
					GrPlot (TextX+c*TextMx+mx,
						TextY+r*TextMy+my, TextBg);
			}
	}
	if (TextBg != -1)
	while (r++ < FONTBLOCK(Font)) {
		for (c = 0; c < FONTWIDTH(Font); ++c)
		  for (mx = 0; mx < TextMx; ++mx)
		    for (my = 0; my < TextMy; ++my)
			GrPlot (TextX+c*TextMx+mx,
				TextY+r*TextMy+my, TextBg);
	}
	TextX += CHARWIDTH(Font);
	_GrFixXY1 ();
}

static void far
_GrCursorXor ()
{
	int	r, c, bits, mx, my;
	uchar	far *fp;

	fp = _GrCursor;

	for (r = 0; r < FONTHEIGHT(Font); ++r) {
		bits = *fp++;
		for (c = 0; c < FONTWIDTH(Font); ++c)
		  for (mx = 0; mx < TextMx; ++mx)
		    for (my = 0; my < TextMy; ++my)
			if (bits & (0x0080 >> c)) {
				if (TextFg != -1)
					GrPlot (TextX+c*TextMx+mx,
						TextY+r*TextMy+my,
						GrXOR|(TextFg&~GrOR));
			} else {
				if (TextBg != -1)
					GrPlot (TextX+c*TextMx+mx,
						TextY+r*TextMy+my,
						GrXOR|(TextBg&~GrOR));
			}
	}
	while (r++ < FONTBLOCK(Font)) {
		for (c = 0; c < FONTWIDTH(Font); ++c)
		  for (mx = 0; mx < TextMx; ++mx)
		    for (my = 0; my < TextMy; ++my)
			GrPlot (TextX+c*TextMx+mx,
				TextY+r*TextMy+my, GrXOR|(TextBg&~GrOR));
	}
}

extern void far
GrFontSet (text)
char	*text;
{
	strcpy (FontName, text);
	if (Font)
		free (Font);
	Font = NULL;
}

extern void far
GrTextChar (c)
int	c;
{
	int	cursave;

	if (Font == 0)
		_GrInit ();

	cursave = GrCursorMode (0);
	_GrTextChar (c);
	(void)GrCursorMode (cursave);
}

extern void far
GrText (text)
char	*text;
{
	int	cursave;

	if (Font == 0)
		_GrInit ();

	cursave = GrCursorMode (0);

	while (*text++)

		_GrTextChar (*text);
	(void)GrCursorMode (cursave);
}

extern void far
GrTextPut (c)
int	c;
{
	int	cursave;

	if (Font == 0)
		_GrInit ();

	cursave = GrCursorMode (0);
	_GrFixXY1 ();

	switch (c) {
	case '\a':
		putch ('\a');
		break;
	case '\b':
		TextX -= CHARWIDTH(Font);
		break;
	case '\f':
		TextX = TextXl;
		TextY = TextYl;
		break;
	case '\n':
		TextX = TextXl;
		TextY += BLOCHEIGHT(Font);
		break;
	case '\r':
		TextX = TextXl;
		break;
	case '\t':
		c = TextX / CHARWIDTH(Font);
		c = (c / 8 + 1) * 8;
		TextX = c * CHARWIDTH(Font);
		break;
	case '\v':
		c = TextY / BLOCHEIGHT(Font);
		c = (c / 8 + 1) * 8;
		TextY = c * BLOCHEIGHT(Font);
		break;
	default:
		_GrTextChar (c);
		break;
	}
	_GrFixXY1 ();
	(void)GrCursorMode (cursave);
}

extern void far
GrTextF (text)
char	*text;
{
	int	c;
	int	cursave;

	if (Font == 0)
		_GrInit ();

	cursave = GrCursorMode (0);

	while (c = *text++)
		GrTextPut (c);

	(void)GrCursorMode (cursave);
}

extern void far
GrTextXY (x, y, text, fg, bg)
int	x;
int	y;
char	*text;
int	fg;
int	bg;
{
	int	cursave;

	cursave = GrCursorMode (0);

	TextX = x;
	TextY = y;
	TextFg = fg;
	TextBg = bg;
	GrText (text);

	(void)GrCursorMode (cursave);
}

extern void far
GrTextSet (x, y, fg, bg, mx, my)
int	x;
int	y;
int	fg;
int	bg;
int	mx;
int	my;
{
	int	cursave;

	if (Font == 0)
		_GrInit ();
	cursave = GrCursorMode (0);

	TextX = x;
	TextY = y;
	TextFg = fg;
	TextBg = bg;
	TextMx = mx;
	TextMy = my;
	if (TextX < TextXl)
		TextX = TextXl;
	if (TextX > TextXh)
		TextX = TextXh;
	if (TextY < TextYl)
		TextY = TextYl;
	if (TextY > TextYh)
		TextY = TextYh;

	_GrTextSetMax();
	(void)GrCursorMode (cursave);
}

extern void far
GrTextColor (fg, bg)
int	fg;
int	bg;
{
	int	cursave;

	cursave = GrCursorMode (0);

	TextFg = fg;
	TextBg = bg;

	(void)GrCursorMode (cursave);
}

extern void far
GrTextGet (x, y, fg, bg, mx, my)
int	*x;
int	*y;
int	*fg;
int	*bg;
int	*mx;
int	*my;
{
	if (x)
		*x = TextX;
	if (y)
		*y = TextY;
	if (fg)
		*fg = TextFg;
	if (bg)
		*bg = TextBg;
	if (mx)
		*mx = TextMx;
	if (my)
		*my = TextMy;
}

extern int far
GrTextPush ()
{
	_GrStack[_GrStackP].x = TextX;
	_GrStack[_GrStackP].y = TextY;
	_GrStack[_GrStackP].xl = TextXl;
	_GrStack[_GrStackP].yl = TextYl;
	_GrStack[_GrStackP].xh = TextXh;
	_GrStack[_GrStackP].yh = TextYh;
	_GrStack[_GrStackP].fg = TextFg;
	_GrStack[_GrStackP].bg = TextBg;
	_GrStack[_GrStackP].mx = TextMx;
	_GrStack[_GrStackP].my = TextMy;
	_GrStack[_GrStackP].scroll = _GrScroll;
	_GrStack[_GrStackP].cursor = _GrCursorMode;
	++_GrStackP;
	return (0);
}

extern int far
GrTextPop ()
{
	int	cursave;

	if (_GrStackP <= 0)
		return (1);
	cursave = GrCursorMode (0);
	--_GrStackP;
	TextX = _GrStack[_GrStackP].x;
	TextY = _GrStack[_GrStackP].y;
	TextXl = _GrStack[_GrStackP].xl;
	TextYl = _GrStack[_GrStackP].yl;
	TextXh = _GrStack[_GrStackP].xh;
	TextYh = _GrStack[_GrStackP].yh;
	TextFg = _GrStack[_GrStackP].fg;
	TextBg = _GrStack[_GrStackP].bg;
	TextMx = _GrStack[_GrStackP].my;
	TextMy = _GrStack[_GrStackP].mx;
	_GrScroll = _GrStack[_GrStackP].scroll;
	_GrCursorMode = _GrStack[_GrStackP].cursor;
	_GrTextSetMax ();
	(void)GrCursorMode (cursave);
	return (0);
}

static char _Gbuf[1024];

extern int far
gprintf (const char *fmt, ...)
{
	va_list	ap;
	int	i;

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);
	GrTextF (_Gbuf);
	return (i);
}

extern int far
GrTextRow (row)
int	row;
{
	if (Font == 0)
		_GrInit ();
	return (row * BLOCHEIGHT(Font));
}

extern int far
GrTextCol (col)
int	col;
{
	if (Font == 0)
		_GrInit ();
	return (col * CHARWIDTH(Font));
}

extern void far
GrTextGoto (row, col)
int	row;
int	col;
{
	int	cursave;

	cursave = GrCursorMode (0);

	TextX = TextXl + GrTextCol(col-1);
	TextY = TextYl + GrTextRow (row-1);
	if (TextX < TextXl)
		TextX = TextXl;
	else if (TextX > TextXh)
		TextX = TextXh;
	if (TextY < TextYl)
		TextY = TextYl;
	else if (TextY > TextYh)
		TextY = TextYh;

	(void)GrCursorMode (cursave);
}

extern void far
GrTextClear ()
{
	int	cursave;

	cursave = _GrCursorMode;
	_GrCursorMode = 0;

	GrClear (TextXl, TextYl, TextXh-TextXl, TextYh-TextYl, TextBg);

	(void)GrCursorMode (cursave);
}

extern int far
GrCursorMode (mode)
int	mode;
{
	int	cursave;

	cursave = _GrCursorMode;
	if (_GrCursorMode != mode) {
		if (Font == 0)
			_GrInit ();
		_GrCursorXor ();
		_GrCursorMode = mode;
	}
	return (cursave);
}

extern void far
GrCursorSet (c, s, e)
uchar	far *c;
int	s;
int	e;
{
	(void)GrCursorMode (0);

	if (c)
		_GrCursor = c;
	else {
		if (s < e) {
			memset (_GrCursorDef, 0, sizeof (_GrCursorDef));
			while (s < e)
				_GrCursorDef[s++] = 0xff;
		}
		_GrCursor = _GrCursorDef;
	}

	(void)GrCursorMode (1);
}
extern void far
GrCursorGet (c, mode)
uchar	*far *c;
int	*mode;
{
	if (c)
		*c = _GrCursor;
	if (mode)
		*mode = _GrCursorMode;
}

extern void far
GrCursorInsMode (mode)
int	mode;
{
	if (Font == 0)
		_GrInit ();

	GrCursorSet (0, FONTHEIGHT(Font)-(mode ? 4 : 2), FONTHEIGHT(Font));
}

extern void far
GrScroll (n)
int	n;
{
	int	hh, ww, ct, cf, ch, b, bh, cursave;

	cursave = GrCursorMode (0);

	hh = TextYh - TextYl;
	ww = TextXh - TextXl;
	if (n > 0) {
		ct = TextYl;
		cf = ct + n;
		ch = hh - n;
		if (ch < 0) {
			ch = 0;
			b = TextYl;
			bh = hh;
			TextY = TextYl;
		} else {
			b = TextYh - n;
			bh = n;
			TextY -= n;
		}
	} else if (n < 0) {
		ct = TextYh - 1;
		cf = ct + n;
		ch = hh + n;
		if (ch < 0) {
			ch = 0;
			b = TextYl;
			bh = hh;
			TextY = TextYm;
		} else {
			b = TextYl;
			bh = n;
			TextY -= n;
		}
	} else
		goto ret;

	if (ch)
		GrCopy (TextXl, cf, TextXl, ct, ww, ch);
	GrClear (TextXl, b, ww, bh, TextBg);

	_GrFixXY1 ();
ret:
	(void)GrCursorMode (cursave);
}

extern void far
GrScrollOn ()
{
	_GrScroll = 1;
}

extern void far
GrScrollOff ()
{
	_GrScroll = 0;
}

extern void far
GrTextWin (xl, xh, yl, yh, bd, bg)
int	xl;
int	xh;
int	yl;
int	yh;
int	bd;
int	bg;
{
	int	cursave, bsize;

	if (Font == 0)
		_GrInit ();

	cursave = GrCursorMode (0);

	TextXl = xl;
	TextXh = xh;
	TextYl = yl;
	TextYh = yh;

	bsize = 2*(bd == -1);

	if (TextXl < 0)
		TextXl = 0;
	else if (TextXl > GrSizeX()-GrTextCol(1)-bsize)
		TextXl = GrSizeX()-GrTextCol(1)-bsize;

	if (TextXh < GrTextCol(1)+bsize)
		TextXh = GrTextCol(1)+bsize;
	else if (TextXh > GrSizeX())
		TextXh = GrSizeX();

	if (TextYl < 0)
		TextYl = 0;
	else if (TextYl > GrSizeY()-GrTextRow(1)-bsize)
		TextYl = GrSizeY()-GrTextRow(1)-bsize;

	if (TextYh < GrTextRow(1)+bsize)
		TextYh = GrTextRow(1)+bsize;
	else if (TextYh > GrSizeY())
		TextYh = GrSizeY();

	if (bd != -1) {
		--TextXh;
		--TextYh;
		GrMoveTo (TextXl, TextYl);
		GrDrawTo (TextXl, TextYh, bd);
		GrDrawTo (TextXh, TextYh, bd);
		GrDrawTo (TextXh, TextYl, bd);
		GrDrawTo (TextXl, TextYl, bd);
		++TextXl;
		++TextYl;
	}
	TextX = TextXl;
	TextY = TextYl;
	if (bg != -1)
		GrClear (TextXl, TextYl, TextXh-TextXl, TextYh-TextYl, bg);
	_GrTextSetMax ();
	(void)GrCursorMode (cursave);
}
