; File Name   :	MT32.DRV
; Format      :	Binary file
; Base Address:	0000h Range: 0000h - 0AB7h Loaded length: 0AB7h

		.386
		.model flat

; ===========================================================================

; Segment type:	Pure code
seg000		segment	byte public 'CODE' use16
		assume cs:seg000
		assume es:nothing, ss:nothing, ds:nothing, fs:nothing, gs:nothing
		jmp	DriverEntry
; ---------------------------------------------------------------------------
		db    0
		db  21h	; !
		db  43h	; C
		db  65h	; e
		db  87h	; 
		db    1
		db    5
		db  6Dh	; m
		db  74h	; t
		db  64h	; d
		db  72h	; r
		db  76h	; v
		db  23h	; #
		db  52h	; R
		db  6Fh	; o
		db  6Ch	; l
		db  61h	; a
		db  6Eh	; n
		db  64h	; d
		db  20h
		db  4Dh	; M
		db  54h	; T
		db  2Dh	; -
		db  33h	; 3
		db  32h	; 2
		db  20h
		db  2Bh	; +
		db  20h	; 
		db  53h ; S
		db  6Fh	; o
		db  75h	; u
		db  6Eh	; n
		db  64h	; d
		db  62h	; b
		db  6Ch	; l
		db  61h ; a
		db  73h	; s
		db  74h	; t
		db  65h	; e
		db  72h	; r
		db  00h	; 
		db  00h
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db  16h
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db  0Dh
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    8
byte_49		db 0			; DATA XREF: sub_969+Ew sub_969+3Cw ...
byte_4A		db 0			; DATA XREF: sub_969+14w sub_969+41w ...
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    5
byte_51		db 0			; DATA XREF: sub_8E3+70w
byte_52		db 0			; DATA XREF: sub_8E3+62w sub_8E3+68r ...
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    3
		db    1
		db  43h	; C
		db    0
		db  39h	; 9
		db 0F7h	; 
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  20h
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
word_A2		dw 0			; DATA XREF: sub_560+8r seg000:08B9r
byte_A4		db 0			; DATA XREF: sub_187+A5r sub_187+ACr
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db    1
byte_AD		db 0			; DATA XREF: sub_5CB+Cw
byte_AE		db 0			; DATA XREF: sub_5CB+16w
byte_AF		db 0			; DATA XREF: sub_5CB+20w
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db  20h
		db  20h
		db  20h
		db  4Dh	; M
		db  50h	; P
		db  55h	; U
		db  20h
		db  49h	; I
		db  4Eh	; N
		db  49h	; I
		db  54h	; T
		db  20h
		db  45h	; E
		db  52h	; R
		db  52h	; R
		db  4Fh	; O
		db  52h	; R
		db  20h
		db  20h
		db  20h
byte_E5		db 0			; DATA XREF: seg000:0141w
					; seg000:loc_158w ...
byte_E6		db 0			; DATA XREF: sub_2F9+2Cw sub_2F9+33r ...
byte_E7		db 0			; DATA XREF: sub_187+D7w
					; sub_336:loc_375r ...
byte_E8		db 0			; DATA XREF: sub_336+E3r sub_336+109w
byte_E9		db 0			; DATA XREF: sub_2F9:loc_313r
					; sub_336+F1w ...
		db    0
byte_EB		db 0			; DATA XREF: sub_336+E8r sub_336+114w
byte_EC		db 0			; DATA XREF: sub_187+DDw sub_2F9+Ar ...
byte_ED		db 0			; DATA XREF: sub_336+DDw sub_336+FBw
byte_EE		db 0			; DATA XREF: sub_187+F8w sub_529+7w ...
byte_EF		db 0			; DATA XREF: sub_187+A0r sub_5CB+2w ...
word_F0		dw 0			; DATA XREF: sub_187:loc_24Ar
					; seg000:0650w	...
word_F2		dw 0			; DATA XREF: sub_187+EAw sub_661+2w ...
word_F4		dw 0			; DATA XREF: sub_187+E3w sub_336+29r ...
word_F6		dw 0			; DATA XREF: sub_187+F1w sub_661+42r ...
word_F8		dw 0			; DATA XREF: sub_187+FEw sub_4FC+1Fw ...
word_FA		dw 0			; DATA XREF: sub_187+D0w sub_336+Er ...
word_FC		dw 0			; DATA XREF: seg000:0120w sub_187r ...
word_FE		dw 0			; DATA XREF: sub_336+3Aw
					; sub_336:loc_4ECr ...
word_100	dw 0			; DATA XREF: sub_560+1Ar seg000:08C2w
word_102	dw 0			; DATA XREF: sub_291+12w sub_291+33w ...
		dw GetDeviceInfo
		dw InitDevice
		dw ShutdownDevice
		dw LoadSound
		dw DoSoundEvents
		dw SetVolume
		dw FadeOut
		dw StopSound
		dw PauseSound
		dw SeekSound
; ---------------------------------------------------------------------------

DriverEntry_MT32:
loc_118:				; CODE XREF: seg000:0000j
		pushf
		push	bp
		push	si
		push	di
		push	bx
		push	dx
		push	ds
		push	es
		mov	cs:word_FC, si
		mov	bx, cs:[bp+104h]
		call	bx
		pop	es
		pop	ds
		pop	dx
		pop	bx
		pop	di
		pop	si
		pop	bp
		popf
		retf
; ---------------------------------------------------------------------------

ShutdownDevice:
		push	bx
		call	sub_6D8
		mov	bx, 0DFh ; ''
		call	sub_291
		xor	di, di
		mov	cs:byte_E5, 1Dh

loc_147:				; CODE XREF: seg000:0153j
		mov	bl, cs:[di+3Bh]
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_147
		mov	bx, 1

loc_158:				; CODE XREF: seg000:0165j
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	bl
		cmp	bl, 0Ah
		jl	short loc_158
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		mov	bx, 8Eh	; ''
		call	sub_7C9
		pop	bx
		retn

; =============== S U B	R O U T	I N E =======================================

LoadSound_MT32:
sub_187		proc near		; CODE XREF: seg000:0774p
		mov	bx, cs:word_FC
		mov	di, [bx+8]
		mov	si, [di]
		mov	es, word ptr [di+2]
		mov	word ptr [bx+10h], 1
		cmp	byte ptr es:[si], 0
		jz	short loc_1AE
		cmp	byte ptr es:[si], 2
		jz	short loc_1AE
		mov	word ptr [bx+10h], 3
		mov	ax, 3
		retn
; ---------------------------------------------------------------------------

loc_1AE:				; CODE XREF: sub_187+16j sub_187+1Cj
		push	cx
		mov	word ptr [bx+0Ch], 22h ; '"'
		mov	word ptr [bx+16h], 0
		add	si, 3
		xor	di, di
		mov	cs:byte_E5, 1Dh
		mov	bx, 0DFh ; ''
		call	sub_291

loc_1CA:				; CODE XREF: sub_187+4Fj
		mov	bl, cs:[di+3Bh]
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_1CA
		mov	di, 1

loc_1DB:				; CODE XREF: sub_187+70j
		inc	si
		mov	bl, es:[si]
		inc	si
		test	bl, 1
		jnz	short loc_1E9
		mov	bl, 10h
		jmp	short loc_1EB
; ---------------------------------------------------------------------------

loc_1E9:				; CODE XREF: sub_187+5Cj
		mov	bx, di

loc_1EB:				; CODE XREF: sub_187+60j
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	di
		cmp	di, 9
		jl	short loc_1DB
		mov	bl, es:[si]
		test	bl, 80h
		jnz	short loc_205
		mov	bl, 10h
		jmp	short loc_207
; ---------------------------------------------------------------------------

loc_205:				; CODE XREF: sub_187+78j
		mov	bl, 9

loc_207:				; CODE XREF: sub_187+7Cj
		add	cs:byte_E5, bl
		call	sub_2E6
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		mov	bl, cs:byte_EF
		cmp	bl, cs:byte_A4
		jz	short loc_23B
		mov	bl, cs:byte_A4
		call	sub_5CB

loc_23B:				; CODE XREF: sub_187+AAj
		xor	cx, cx
		cmp	bp, 12h
		jz	short loc_24A
		mov	bx, cs:word_FC
		mov	cx, [bx+18h]

loc_24A:				; CODE XREF: sub_187+B9j
		cmp	cx, cs:word_F0
		jz	short loc_254
		call	sub_560

loc_254:				; CODE XREF: sub_187+C8j
		add	si, 0Eh
		mov	cs:word_FA, 0
		mov	cs:byte_E7, 2
		mov	cs:byte_EC, 0
		mov	cs:word_F4, 0
		mov	cs:word_F2, 8
		mov	cs:word_F6, 0
		mov	cs:byte_EE, 0
		mov	cs:word_F8, 22h	; '"'
		mov	ax, 1
		pop	cx
		retn
sub_187		endp


; =============== S U B	R O U T	I N E =======================================


sub_291		proc near		; CODE XREF: seg000:013Cp sub_187+40p	...
		push	cx
		push	dx
		mov	cx, 0FFFFh
		mov	dx, 331h

loc_299:				; CODE XREF: sub_291+20j
		cmp	bp, 12h
		jz	short loc_2AE
		cmp	cx, 0
		jnz	short loc_2AD
		mov	cs:word_102, 0FFFFh
		jmp	short loc_2E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_2AD:				; CODE XREF: sub_291+10j
		dec	cx

loc_2AE:				; CODE XREF: sub_291+Bj
		in	al, dx
		test	al, 40h
		jnz	short loc_299
		cli
		mov	al, bl
		out	dx, al
		mov	cx, 0FFFFh

loc_2BA:				; CODE XREF: sub_291+44j
		cmp	bp, 12h
		jz	short loc_2D0
		cmp	cx, 0
		jnz	short loc_2CF
		mov	cs:word_102, 0FFFFh
		sti
		jmp	short loc_2E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_2CF:				; CODE XREF: sub_291+31j
		dec	cx

loc_2D0:				; CODE XREF: sub_291+2Cj
		in	al, dx
		rol	al, 1
		jnb	short loc_2D7
		jmp	short loc_2BA
; ---------------------------------------------------------------------------

loc_2D7:				; CODE XREF: sub_291+42j
		mov	dx, 330h
		in	al, dx
		cmp	al, 0FEh ; ''
		jz	short loc_2E2
		mov	ax, 0FFFFh

loc_2E2:				; CODE XREF: sub_291+4Cj
		sti

loc_2E3:				; CODE XREF: sub_291+19j sub_291+3Bj
		pop	dx
		pop	cx
		retn
sub_291		endp


; =============== S U B	R O U T	I N E =======================================


sub_2E6		proc near		; CODE XREF: seg000:014Cp seg000:015Dp ...
		push	ax
		push	dx
		mov	dx, 331h

loc_2EB:				; CODE XREF: sub_2E6+8j
		in	al, dx
		test	al, 40h
		jnz	short loc_2EB
		mov	dx, 330h
		mov	al, bl
		out	dx, al
		pop	dx
		pop	ax
		retn
sub_2E6		endp


; =============== S U B	R O U T	I N E =======================================


sub_2F9		proc near		; CODE XREF: sub_336+1A1p sub_336+1AAp
		push	bx
		or	al, ah
		push	ax
		mov	bl, 0D0h ; ''
		call	sub_291
		pop	ax
		cmp	cs:byte_EC, al
		jz	short loc_313
		mov	bl, al
		call	sub_2E6
		mov	cs:byte_EC, al

loc_313:				; CODE XREF: sub_2F9+Fj
		mov	bl, cs:byte_E9
		call	sub_2E6
		inc	si
		cmp	cx, 2
		jnz	short loc_334
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_E6, dl
		inc	si
		pop	dx
		mov	bl, cs:byte_E6
		call	sub_2E6

loc_334:				; CODE XREF: sub_2F9+26j
		pop	bx
		retn
sub_2F9		endp


; =============== S U B	R O U T	I N E =======================================

DoSoundEvents_MT32:
sub_336		proc near		; CODE XREF: seg000:077Ep
		cli
		mov	bx, cs:word_FC
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]
		cmp	cs:word_FA, 0
		jz	short loc_36C
		cmp	bp, 12h
		jnz	short loc_35A
		mov	cs:word_FA, 0
		jmp	short loc_36A
; ---------------------------------------------------------------------------

loc_35A:				; CODE XREF: sub_336+19j
		dec	cs:word_FA
		cmp	cs:word_F4, 0
		jz	short loc_36A
		call	sub_661

loc_36A:				; CODE XREF: sub_336+22j sub_336+2Fj
		sti
		retn
; ---------------------------------------------------------------------------

loc_36C:				; CODE XREF: sub_336+14j
		push	cx
		add	si, [bx+0Ch]
		mov	cs:word_FE, si

loc_375:				; CODE XREF: sub_336+7Aj sub_336+182j	...
		cmp	cs:byte_E7, 1
		jnz	short loc_3F9
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_E6, dl
		inc	si
		pop	dx
		cmp	cs:byte_E6, 0FCh ; ''
		jnz	short loc_396
		call	sub_540
		jmp	loc_4F9
; ---------------------------------------------------------------------------

loc_396:				; CODE XREF: sub_336+58j
		cmp	cs:byte_E6, 0F8h ; ''
		jnz	short loc_3B7
		mov	cs:word_FA, 0F0h ; ''
		mov	cs:byte_E7, 1
		cmp	bp, 12h
		jnz	short loc_3B4
		jmp	short loc_375
; ---------------------------------------------------------------------------
		db 0EBh	; 
		db    3
; ---------------------------------------------------------------------------

loc_3B4:				; CODE XREF: sub_336+78j
		jmp	loc_4EC
; ---------------------------------------------------------------------------

loc_3B7:				; CODE XREF: sub_336+66j
		push	bx
		mov	cs:byte_E7, 2
		mov	ax, cs:word_FA
		mov	bl, cs:byte_E6
		xor	bh, bh
		add	ax, bx
		mov	cs:word_FA, ax
		pop	bx
		cmp	cs:word_FA, 0
		jz	short loc_3F9
		cmp	bp, 12h
		jnz	short loc_3E6
		mov	cs:word_FA, 0
		jmp	short loc_3F6
; ---------------------------------------------------------------------------

loc_3E6:				; CODE XREF: sub_336+A5j
		dec	cs:word_FA
		cmp	cs:word_F4, 0
		jz	short loc_3F6
		call	sub_661

loc_3F6:				; CODE XREF: sub_336+AEj sub_336+BBj
		jmp	loc_4EC
; ---------------------------------------------------------------------------

loc_3F9:				; CODE XREF: sub_336+45j sub_336+A0j
		mov	cs:byte_E7, 2
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_E6, dl
		inc	si
		pop	dx
		test	cs:byte_E6, 80h
		jnz	short loc_430
		push	bx
		mov	cs:byte_ED, 1
		mov	ah, cs:byte_E8
		mov	al, cs:byte_EB
		mov	bl, cs:byte_E6
		mov	cs:byte_E9, bl
		pop	bx
		dec	si
		jmp	short loc_457
; ---------------------------------------------------------------------------

loc_430:				; CODE XREF: sub_336+DAj
		push	bx
		mov	cs:byte_ED, 0
		mov	ah, cs:byte_E6
		and	ah, 0F0h
		mov	cs:byte_E8, ah
		mov	al, cs:byte_E6
		and	al, 0Fh
		mov	cs:byte_EB, al
		mov	bl, es:[si]
		mov	cs:byte_E9, bl
		pop	bx

loc_457:				; CODE XREF: sub_336+F8j
		cmp	ah, 0C0h ; ''
		jnz	short loc_46B
		cmp	al, 0Fh
		jnz	short loc_468
		call	sub_4FC
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
		db 0EBh	; 
		db    3
; ---------------------------------------------------------------------------

loc_468:				; CODE XREF: sub_336+128j
		jmp	short loc_4DD
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_46B:				; CODE XREF: sub_336+124j
		cmp	ah, 0B0h ; ''
		jnz	short loc_48C
		cmp	cs:byte_E9, 50h	; 'P'
		jnz	short loc_47E
		call	sub_5C2
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_47E:				; CODE XREF: sub_336+140j
		cmp	cs:byte_E9, 4Ch	; 'L'
		jnz	short loc_48C
		call	sub_529
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_48C:				; CODE XREF: sub_336+138j sub_336+14Ej
		cmp	ah, 0D0h ; ''
		jnz	short loc_494
		jmp	short loc_4DD
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_494:				; CODE XREF: sub_336+159j
		cmp	ah, 0F0h ; ''
		jnz	short loc_4BB
		cmp	al, 0Ch
		jnz	short loc_4A5
		call	sub_540
		jmp	short loc_4F9
; ---------------------------------------------------------------------------
		db  90h	; 
		db 0EBh	; 
		db  16h
; ---------------------------------------------------------------------------

loc_4A5:				; CODE XREF: sub_336+165j sub_336+180j
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_E6, dl
		inc	si
		pop	dx
		cmp	cs:byte_E6, 0F7h ; ''
		jnz	short loc_4A5
		jmp	loc_375
; ---------------------------------------------------------------------------

loc_4BB:				; CODE XREF: sub_336+161j
		cmp	bp, 12h
		jnz	short loc_4D4
		cmp	ah, 90h	; ''
		jnz	short loc_4CA
		inc	si
		inc	si
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_4CA:				; CODE XREF: sub_336+18Dj
		cmp	ah, 80h	; ''
		jnz	short loc_4D4
		inc	si
		inc	si
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_4D4:				; CODE XREF: sub_336+188j sub_336+197j
		mov	cx, 2
		call	sub_2F9
		jmp	short loc_4E3
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_4DD:				; CODE XREF: sub_336:loc_468j
					; sub_336+15Bj
		mov	cx, 1
		call	sub_2F9

loc_4E3:				; CODE XREF: sub_336+12Dj sub_336+145j ...
		mov	cs:byte_E7, 1
		jmp	loc_375
; ---------------------------------------------------------------------------

loc_4EC:				; CODE XREF: sub_336:loc_3B4j
					; sub_336:loc_3F6j
		sub	si, cs:word_FE
		mov	bx, cs:word_FC
		add	[bx+0Ch], si

loc_4F9:				; CODE XREF: sub_336+5Dj sub_336+16Aj
		pop	cx
		sti
		retn
sub_336		endp


; =============== S U B	R O U T	I N E =======================================


sub_4FC		proc near		; CODE XREF: sub_336+12Ap
		push	dx
		push	bx
		inc	si
		xor	dh, dh
		mov	dl, cs:byte_E9
		mov	bx, cs:word_FC
		cmp	dl, 7Fh	; ''
		jnz	short loc_523
		push	si
		sub	si, cs:word_FE
		add	si, [bx+0Ch]
		dec	si
		dec	si
		mov	cs:word_F8, si
		pop	si
		jmp	short loc_526
; ---------------------------------------------------------------------------

loc_523:				; CODE XREF: sub_4FC+12j
		mov	[bx+16h], dx

loc_526:				; CODE XREF: sub_4FC+25j
		pop	bx
		pop	dx
		retn
sub_4FC		endp


; =============== S U B	R O U T	I N E =======================================


sub_529		proc near		; CODE XREF: sub_336+150p
		inc	si
		cmp	byte ptr es:[si], 0
		jnz	short loc_538
		mov	cs:byte_EE, 0
		jmp	short loc_53E
; ---------------------------------------------------------------------------

loc_538:				; CODE XREF: sub_529+5j
		mov	cs:byte_EE, 1

loc_53E:				; CODE XREF: sub_529+Dj
		inc	si
		retn
sub_529		endp


; =============== S U B	R O U T	I N E =======================================


sub_540		proc near		; CODE XREF: sub_336+5Ap sub_336+167p	...
		mov	bx, cs:word_FC
		mov	word ptr [bx+16h], 0FFFFh
		mov	dx, cs:word_F8
		mov	[bx+0Ch], dx
		mov	cs:word_FA, 0
		mov	cs:byte_E7, 2
		retn
sub_540		endp


; =============== S U B	R O U T	I N E =======================================


sub_560		proc near		; CODE XREF: sub_187+CAp seg000:0655p	...
		push	di
		push	bx
		push	cx
		cmp	cx, 0Fh
		jl	short loc_56F
		mov	cx, cs:word_A2
		jmp	short loc_583
; ---------------------------------------------------------------------------

loc_56F:				; CODE XREF: sub_560+6j
		cmp	cx, 0
		jle	short loc_583
		push	ax
		push	dx
		xor	dx, dx
		mov	ax, cx
		mul	cs:word_100
		mov	cx, ax
		pop	dx
		pop	ax

loc_583:				; CODE XREF: sub_560+Dj sub_560+12j
		mov	bx, 0DFh ; ''
		call	sub_291
		xor	di, di
		mov	cs:byte_E5, 26h	; '&'

loc_591:				; CODE XREF: sub_560+3Dj
		mov	bl, cs:[di+33h]
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_591
		mov	bx, cx
		add	cs:byte_E5, bl
		call	sub_2E6
		neg	cs:byte_E5
		mov	bl, cs:byte_E5
		and	bl, 7Fh
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		pop	cx
		pop	bx
		pop	di
		retn
sub_560		endp


; =============== S U B	R O U T	I N E =======================================


sub_5C2		proc near		; CODE XREF: sub_336+142p
		inc	si
		mov	bl, es:[si]
		inc	si
		call	sub_5CB
		retn
sub_5C2		endp


; =============== S U B	R O U T	I N E =======================================


sub_5CB		proc near		; CODE XREF: sub_187+B1p sub_5C2+5p
		xor	bh, bh
		mov	cs:byte_EF, bl
		mov	cl, cs:[bx+0B0h]
		mov	cs:byte_AD, cl
		mov	cl, cs:[bx+0BBh]
		mov	cs:byte_AE, cl
		mov	cl, cs:[bx+0C6h]
		mov	cs:byte_AF, cl
		mov	bx, 0DFh ; ''
		call	sub_291
		xor	di, di

loc_5F8:				; CODE XREF: sub_5CB+39j
		mov	bl, cs:[di+0A5h]
		call	sub_2E6
		inc	di
		cmp	di, 5
		jl	short loc_5F8
		mov	cs:byte_E5, 0

loc_60C:				; CODE XREF: sub_5CB+52j
		mov	bl, cs:[di+0A5h]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	di
		cmp	di, 0Bh
		jl	short loc_60C
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		mov	cs:byte_EC, 0
		retn
sub_5CB		endp

; ---------------------------------------------------------------------------

SetVolume_MT32:
		cmp	cs:word_F4, 0
		jnz	short locret_660
		push	bx
		push	cx
		mov	bx, cs:word_FC
		mov	cx, [bx+18h]
		mov	cs:word_F0, cx
		call	sub_560
		mov	cs:byte_EC, 0
		pop	cx
		pop	bx

locret_660:				; CODE XREF: seg000:0644j
		retn

; =============== S U B	R O U T	I N E =======================================


sub_661		proc near		; CODE XREF: sub_336+31p sub_336+BDp
		push	bx
		push	cx
		dec	cs:word_F2
		cmp	cs:word_F2, 0
		jnz	short loc_6B3
		dec	cs:word_F4
		cmp	cs:word_F4, 0
		jnz	short loc_68F
		mov	bx, cs:word_FC
		mov	word ptr [bx+0Ah], 0
		call	sub_6D8
		call	sub_540
		jmp	short loc_6B3
; ---------------------------------------------------------------------------

loc_68F:				; CODE XREF: sub_661+1Aj
		mov	cx, cs:word_F4
		mov	cs:word_F0, cx
		call	sub_560
		mov	cs:word_F2, 8
		mov	cx, cs:word_F6
		add	cs:word_F2, cx
		add	cs:word_F6, 2

loc_6B3:				; CODE XREF: sub_661+Dj sub_661+2Cj
		pop	cx
		pop	bx
		retn
sub_661		endp

; ---------------------------------------------------------------------------

FadeOut_MT32:
		push	bx
		push	cx
		mov	bx, cs:word_FC
		mov	cx, [bx+18h]
		mov	cs:word_F4, cx
		cmp	cx, 0
		jnz	short loc_6D5
		mov	word ptr [bx+0Ah], 0
		call	sub_6D8
		call	sub_540

loc_6D5:				; CODE XREF: seg000:06C8j
		pop	cx
		pop	bx
		retn

; =============== S U B	R O U T	I N E =======================================

PauseSound_MT32:
StopSound_MT32:
sub_6D8		proc near		; CODE XREF: seg000:0136p sub_661+26p	...
		push	cx
		mov	cs:byte_EC, 0
		mov	di, 1
		xor	bh, bh

loc_6E4:				; CODE XREF: sub_6D8+61j
		mov	bl, 0D0h ; ''
		call	sub_291
		cmp	cs:word_102, 0FFFFh
		jnz	short loc_6F3
		pop	cx
		retn
; ---------------------------------------------------------------------------

loc_6F3:				; CODE XREF: sub_6D8+17j
		mov	bl, 0B0h ; ''
		add	bx, di
		call	sub_2E6
		mov	bl, 7Bh	; '{'
		call	sub_2E6
		xor	bl, bl
		call	sub_2E6
		mov	bl, 0D0h ; ''
		call	sub_291
		mov	bl, 0B0h ; ''
		add	bx, di
		call	sub_2E6
		mov	bl, 40h	; '@'
		call	sub_2E6
		xor	bl, bl
		call	sub_2E6
		cmp	bp, 10h
		jz	short loc_735
		mov	bl, 0D0h ; ''
		call	sub_291
		mov	bl, 0E0h ; ''
		add	bx, di
		call	sub_2E6
		xor	bl, bl
		call	sub_2E6
		mov	bl, 40h	; '@'
		call	sub_2E6

loc_735:				; CODE XREF: sub_6D8+45j
		inc	di
		cmp	di, 0Ah
		jl	short loc_6E4
		cmp	bp, 0Eh
		jnz	short loc_743
		call	sub_540

loc_743:				; CODE XREF: sub_6D8+66j
		cmp	bp, 10h
		jnz	short loc_767
		cmp	cs:byte_EE, 0
		jz	short loc_767
		mov	bx, cs:word_FC
		mov	word ptr [bx+0Ch], 22h ; '"'
		mov	cs:word_FA, 0
		mov	cs:byte_E7, 2

loc_767:				; CODE XREF: sub_6D8+6Ej sub_6D8+76j
		pop	cx
		retn
sub_6D8		endp

; ---------------------------------------------------------------------------

SeekSound:
		cli
		push	cx
		mov	bx, cs:word_FC
		mov	cx, [bx+0Ch]
		push	si
		call	sub_187
		pop	si
		cmp	ax, 1
		jnz	short loc_795

loc_77D:				; CODE XREF: seg000:0793j
		push	si
		call	sub_336
		pop	si
		mov	bx, cs:word_FC
		cmp	word ptr [bx+16h], 0FFFFh
		jnz	short loc_790
		mov	cx, [bx+0Ch]

loc_790:				; CODE XREF: seg000:078Bj
		cmp	[bx+0Ch], cx
		jb	short loc_77D

loc_795:				; CODE XREF: seg000:077Bj
		cmp	cs:byte_EE, 0
		jz	short loc_7AF
		mov	word ptr [bx+0Ch], 22h ; '"'
		mov	cs:word_FA, 0
		mov	cs:byte_E7, 2

loc_7AF:				; CODE XREF: seg000:079Bj
		cmp	word ptr [bx+18h], 0
		jz	short loc_7C0
		mov	cx, [bx+18h]
		mov	cs:word_F0, cx
		call	sub_560

loc_7C0:				; CODE XREF: seg000:07B3j
		mov	cs:byte_EC, 0
		pop	cx
		sti
		retn

; =============== S U B	R O U T	I N E =======================================


sub_7C9		proc near		; CODE XREF: seg000:0182p seg000:084Dp ...
		push	di
		push	cx
		push	bx
		mov	bx, 0DFh ; ''
		call	sub_291
		mov	cs:byte_E5, 20h	; ' '
		xor	di, di

loc_7DA:				; CODE XREF: sub_7C9+1Dj
		mov	bl, cs:[di+5Eh]
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_7DA
		pop	bx
		xor	di, di

loc_7EB:				; CODE XREF: sub_7C9+35j
		mov	cl, cs:[bx+di]
		push	bx
		mov	bl, cl
		add	cs:byte_E5, bl
		call	sub_2E6
		pop	bx
		inc	di
		cmp	di, 14h
		jl	short loc_7EB
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		pop	cx
		pop	di
		retn
sub_7C9		endp

;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================

; "GM on MPU-401 driver for SCI0"
;
;
; byte_20A6 = pcm play state (0 = stop, 1 = ready, 2 = playing, 4 = paused)
; byte_20A7 = sb dma pass
; word_20B0 = ptrparam - saves the original si parameter to DriverInterface
;
;
; sound info structure
; +08h = SND_RESPTR (far ptr to data)
; +0Ah = SND_UNK
; +0Ch = SND_POS (play offset)
; +10h = SND_STATE (1 = okay)
; +16h = SND_SIGNAL (0 = ready?, FFFF = stop)
; +18h = SND_VOLUME


; Soundblaster vars
; word_2025 = i/o port
; byte_2027 = dma irq
; word_2028 = dma busy (0 = idle, 1 = active)



word_2025 dw 220h
byte_2027	db 00h
word_2028 dw 00h

byte_202C db 00h
word_202D dw 00h
word_202F dw 00h
word_2031 dw 00h




byte_20A6 db 00h
byte_20A7 db 00h


word_20B0 dw 00h
word_20B4 dw 00h
	dw 00h




; interrupt vectors - 2/3/5/7
word_irqh	dw 0
	dw 0
word_irq2	dw 0
	dw 0
word_irq5	dw 0
	dw 0
word_irq3	dw 0
	dw 0
word_irq7 dw 0
	dw 0


byte_sbvol db 0



byte_2459	db 0			; DATA XREF: sub_26CA+36r sub_26CA+4Cw ...
word_245A	dw 0			; DATA XREF: sub_26CA:loc_26DFr
					; sub_26CA+3Br	...
word_245C	dw 0			; DATA XREF: sub_26CA+1Aw sub_26CA+3Fr ...
byte_245E	db 0			; DATA XREF: sub_26CA+3r sub_26CA+Bw ...
word_245F	dw 0			; DATA XREF: sub_26CA+22w sub_27A6+65w
word_2461	dw 0			; DATA XREF: sub_26CA+27w
					; sub_26CA:loc_26F9w ...
word_2463	dw 0			; DATA XREF: sub_26CA+10r sub_27A6+7Fw

; ---------------------------------------------------------------------------

; NOTE:
; - preserve original driver code + code order
; - 'external' jmps to bypass missing hard-coded ptrs


DriverEntry:
		; sblaster - data ptr
		mov cs:word_20B0, si

		jmp DriverEntry

; ---------------------------------------------------------------------------


LoadSound:
		mov	bx, cs:word_20B0
		mov	di, [bx+8]
		mov	si, [di]
		mov	es, word ptr [di+2]
		mov	word ptr [bx+10h], 1


		; sblaster - no pcm data
		mov	cs:byte_20A6, 0


		cmp	byte ptr es:[si], 2
		jne	LoadSound_MT32

		jmp	LoadSound_SB


; =============== S U B	R O U T	I N E =======================================


LoadSound_SB:
sub_1920	proc near		; CODE XREF: sub_177D:loc_17B2.p
					; sub_19B3+31.p
		mov	ax, es:[si+1Fh]
		xchg	ah, al
		or	ax, ax
		jnz	short loc_193E

		; 0000 = find PCM header

		; skip MIDI header
		add	si, 21h	; '!'

loc_192D:				; CODE XREF: sub_1920+12.j
		; look for $FC MIDI stop byte
		inc	si
		cmp	byte ptr es:[si], 0FCh ; ''
		jnz	short loc_192D

		; look for $FC PCM pad
		cmp	byte ptr es:[si+1], 0FCh ; ''
		jnz	short loc_193C
		inc	si

loc_193C:				; CODE XREF: sub_1920+19.j
		jmp	short loc_1940
; ---------------------------------------------------------------------------

loc_193E:				; CODE XREF: sub_1920+8.j
		; use PCM offset value
		add	si, ax

loc_1940:				; CODE XREF: sub_1920:loc_193C.j
		; check frequency
		mov	cx, es:[si+0Fh]
		cmp	cx, 0F34h
		jge	short loc_1953

		mov	cs:byte_202C, 0
		jmp	short loc_1964
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_1953:				; CODE XREF: sub_1920+28.j
		; 1000000d = timer compute
		mov	dx, 0Fh
		mov	ax, 4240h
		div	cx
		mov	ah, 0
		sub	ah, al
		mov	cs:byte_202C, ah

loc_1964:				; CODE XREF: sub_1920+30.j
		mov	ax, es:[si+21h]
		mov	cs:word_2031, ax
		add	si, 2Dh	; '-'
		mov	cs:word_202D, es
		mov	cs:word_202F, si
		mov	cs:word_20B4, si
		mov	bx, cs:word_20B0
		mov	[bx+0Ch], si
		mov	word ptr [bx+16h], 0

		mov	ax, [bx+18h]
		or	al, al
		jz	short loc_1994
		mov	al, 1

loc_1994:				; CODE XREF: sub_1920+70.j
		cmp	cs:byte_20A7, al
		jz	short loc_19A2
		mov	cs:byte_20A7, al
		call	sub_2788

loc_19A2:				; CODE XREF: sub_1920+79.j
		mov	cs:byte_20A6, 1
		mov	cs:word_2028, 0
		mov	ax, 1
		retn
sub_1920	endp

; =============== S U B	R O U T	I N E =======================================


DoSoundEvents:
		mov	bx, cs:word_20B0
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]



		; 0 = pcm n/a
		cmp	cs:byte_20A6, 0
		je DoSoundEvents_MT32



		; 1 = pcm ready
		cmp	cs:byte_20A6, 1
		jnz	short loc_19D3

		; start sb dma
		call	sub_27A6


loc_19D3:				; CODE XREF: sub_19B3+1B.j
		cmp	cs:word_2028, 0
		jne	short loc_19F8

		; dma not active - check replay
		cmp	word ptr [bx+0Ah], 1
		jle	short loc_19EC


		; replay sound = reload + send dma
		dec	word ptr [bx+0Ah]
		call	sub_1920
		call	sub_27A6
		retn
; ---------------------------------------------------------------------------

loc_19EC:				; CODE XREF: sub_19B3+2C.j
		; terminate pcm
		mov	word ptr [bx+16h], 0FFFFh
		mov	cs:byte_20A6, 0
		retn
; ---------------------------------------------------------------------------

loc_19F8:				; CODE XREF: sub_19B3+26.j
		; restart pcm if paused
		cmp	cs:byte_20A6, 4
		jnz	short locret_1A03

		call	sub_2892

locret_1A03:				; CODE XREF: sub_19B3+4B.j
		retn

; ---------------------------------------------------------------------------


SetVolume:
		push ax
		push bx

		mov bx, cs:word_20B0
		mov al, [bx+18h]
		mov cs:byte_sbvol, al
		call SetVolume_SB

		pop bx
		pop ax


		jmp SetVolume_MT32

; ---------------------------------------------------------------------------

SetVolume_SB:
		push ax
		push bx
		push dx


		; volume (0-F, 0-F)
		; - sbpro = 3-bits used (xxx-)
		; - sb16 = 4-bits (xxxx)
		mov bl, cs:byte_sbvol
		and bl, 0Eh


		; sbpro dac volume register
		mov	dx, cs:word_2025
		add	dx, 04h
		mov al, 04h
		out dx, al

		mov	dx, cs:word_2025
		add	dx, 05h
		mov al, bl
		shl al, 4
		or al, bl
		out dx, al

; ---------------------------------------------------------------------------

		; check if pcm playing
		cmp	cs:byte_20A6, 2
		jne SetVolume_end


		; check active pcm
		mov	bx, cs:word_20B0
		cmp	word ptr [bx+18h], 0
		jnz	short loc_2A3F

		xor	al, al
		jmp	short loc_2A41

; ---------------------------------------------------------------------------

loc_2A3F:				; CODE XREF: seg000:2A39.j
		mov	al, 1

loc_2A41:				; CODE XREF: seg000:2A3D.j
		call	sub_2788


SetVolume_end:
		pop dx
		pop bx
		pop ax

		retn


; =============== S U B	R O U T	I N E =======================================


FadeOut:
		cmp	cs:word_2028, 0
		je FadeOut_MT32



		push bx
		push cx

		; stop dma
		call	sub_2843

		; stop pcm
		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh
		mov	word ptr [bx+0Ah], 0

		pop cx
		pop bx
		retn

; =============== S U B	R O U T	I N E =======================================


StopSound:
		cmp	cs:word_2028, 0
		je StopSound_MT32


		push bx
		push cx

		; stop sb dma
		call	sub_2843

		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh

		pop cx
		pop bx
		retn

; =============== S U B	R O U T	I N E =======================================


PauseSound:
		cmp	cs:word_2028, 1
		jne	PauseSound_MT32


		push bx
		push cx

		; active pcm play - check pause / stop
		cmp	bp, 10h
		jnz	short loc_2B0A

		; pause dma
		call	sub_286D
		mov	cs:byte_20A6, 4
		jmp PauseSound_End

; ---------------------------------------------------------------------------

loc_2B0A:				; CODE XREF: sub_2AF2+B.j
		; stop sb dma
		call	sub_2843

		; stop pcm play
		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh


PauseSound_End:
		pop cx
		pop bx
		retn

; ---------------------------------------------------------------------------

sb_irqHandler:
		push	ds
		push	es
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		push	si
		push	bp
		cli
		cld
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.


		mov	ax, cs:word_245F
		or	ax, ax
		jnz	short loc_26B3
		call	sub_273F
		jmp	short loc_26B6
; ---------------------------------------------------------------------------

loc_26B3:				; CODE XREF: seg000:26AC.j
		call	sub_26CA

loc_26B6:				; CODE XREF: seg000:26B1.j
		mov	dx, cs:word_2025
		add	dl, 0Eh
		in	al, dx
		sti
		pop	bp
		pop	si
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		pop	es
		pop	ds
		iret

; =============== S U B	R O U T	I N E =======================================


sub_2496	proc near		; CODE XREF: sub_250D+2F.p sub_250D+34.p ...
		mov	ah, al

loc_2498:				; CODE XREF: sub_2496+5.j
		in	al, dx
		or	al, al
		js	short loc_2498
		mov	al, ah
		out	dx, al
		retn
sub_2496	endp


; =============== S U B	R O U T	I N E =======================================


sub_259E	proc near		; CODE XREF: sub_2843+16.p sub_286D+15.p
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 0D0h ; ''
		call	sub_2496

loc_25AB:				; CODE XREF: sub_259E+10.j
		in	al, dx
		or	al, al
		js	short loc_25AB
		retn
sub_259E	endp


; =============== S U B	R O U T	I N E =======================================


sub_25B1	proc near		; CODE XREF: sub_250D+22.p sub_26CA+44.p
		push	bx
		mov	bx, ax
		mov	al, 5
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)
		xor	al, al
		out	0Ch, al		; DMA controller, 8237A-5.
					; clear	byte pointer flip-flop.
		mov	al, dh
		out	0Bh, al		; DMA 8237A-5. mode register bits:
					; 0-1: channel (00=0; 01=1; 10=2; 11=3)
					; 2-3: transfer	type (00=verify=Nop; 01=write; 10=read)
					; 4: 1=enable auto-initialization
					; 5: 1=address increment; 0=address decrement
					; 6-7: 00=demand mode; 01=single; 10=block; 11=cascade
		mov	al, bl
		out	2, al		; DMA controller, 8237A-5.
					; channel 1 base address
					; (also	sets current address)
		mov	al, bh
		out	2, al		; DMA controller, 8237A-5.
					; channel 1 base address
					; (also	sets current address)
		mov	al, cl
		out	3, al		; DMA controller, 8237A-5.
					; channel 1 base address and word count
		mov	al, ch
		out	3, al		; DMA controller, 8237A-5.
					; channel 1 base address and word count
		mov	al, dl
		out	83h, al		; DMA page register 74LS612:
					; Channel 1 (address bits 16-23)
		mov	al, 1
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)
		pop	bx
		retn
sub_25B1	endp


; =============== S U B	R O U T	I N E =======================================


sub_25DA	proc near		; CODE XREF: sub_250D+1B.p sub_27A6+54.p
		push	cx
		mov	cl, 4
		rol	dx, cl
		mov	cx, dx
		and	dx, 0Fh
		and	cx, 0FFF0h
		add	ax, cx
		adc	dx, 0
		pop	cx
		retn
sub_25DA	endp


; =============== S U B	R O U T	I N E =======================================


sub_25EE	proc near		; CODE XREF: sub_250D+8.p sub_250D+13.p	...
		push	bx
		push	cx
		push	dx
		cli
		mov	cl, al
		add	al, 8
		cbw
		shl	al, 1
		shl	al, 1
		mov	di, ax
		push	es
		xor	ax, ax
		mov	es, ax
		mov	ax, es:[di]
		mov	cs:[bx], ax
		mov	es:[di], dx
		mov	ax, es:[di+2]
		mov	cs:[bx+2], ax
		mov	word ptr es:[di+2], cs
		pop	es
		mov	ah, 1
		shl	ah, cl
		not	ah
		in	al, 21h		; Interrupt controller,	8259A.
		and	al, ah
		out	21h, al		; Interrupt controller,	8259A.
		sti
		pop	dx
		pop	cx
		pop	bx
		retn
sub_25EE	endp

; =============== S U B	R O U T	I N E =======================================


sub_2629	proc near		; CODE XREF: sub_250D+5E.p sub_250D+66.p ...
		cli
		mov	cl, al
		add	al, 8
		cbw
		shl	al, 1
		shl	al, 1
		mov	di, ax
		push	es
		xor	ax, ax
		mov	es, ax
		mov	ax, cs:[bx]
		mov	es:[di], ax
		mov	ax, cs:[bx+2]
		mov	es:[di+2], ax
		pop	es
		mov	ah, 1
		shl	ah, cl
		in	al, 21h		; Interrupt controller,	8259A.
		or	al, ah
		out	21h, al		; Interrupt controller,	8259A.
		sti
		retn
sub_2629	endp


; =============== S U B	R O U T	I N E =======================================


sub_26CA	proc near		; CODE XREF: sub_27A6+8Dp
		mov	cx, 0FFFFh
		cmp	cs:byte_245E, 0
		jnz	short loc_26DF
		inc	cs:byte_245E
		mov	cx, cs:word_2463

loc_26DF:				; CODE XREF: sub_26CA+9j
		sub	cx, cs:word_245A
		mov	cs:word_245C, cx
		inc	cx
		jz	short loc_26F9
		sub	cs:word_245F, cx
		sbb	cs:word_2461, 0
		jmp	short loc_26FE
; ---------------------------------------------------------------------------

loc_26F9:				; CODE XREF: sub_26CA+20j
		dec	cs:word_2461

loc_26FE:				; CODE XREF: sub_26CA+2Dj
		mov	dh, 49h	; 'I'
		mov	dl, cs:byte_2459
		mov	ax, cs:word_245A
		mov	cx, cs:word_245C
		call	sub_25B1
		dec	cs:byte_245E
		inc	cs:byte_2459
		mov	cs:word_245A, 0
		mov	cx, cs:word_245C
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 14h
		call	sub_2496
		mov	al, cl
		call	sub_2496
		mov	al, ch
		call	sub_2496
		retn
sub_26CA	endp


; =============== S U B	R O U T	I N E =======================================


sub_273F	proc near		; CODE XREF: sub_2843+19p
		mov	al, 5
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)

		; restore old irq
		mov	al, cs:byte_2027
		mov	bx, offset word_irqh
		call	sub_2629

		; dma active = no
		mov	cs:word_2028, 0

		mov	dx, cs:word_2025
		add	dl, 0Eh
		in	al, dx
		retn
sub_273F	endp


; =============== S U B	R O U T	I N E =======================================


sub_2788	proc near		; CODE XREF: sub_1920+7Fp
					; seg000:loc_2A41p
		push	ds
		call	sub_278E
		pop	ds
		retn
sub_2788	endp


; =============== S U B	R O U T	I N E =======================================


sub_278E	proc near		; CODE XREF: sub_275E+20.p sub_2788+1.p
		mov	dx, cs:word_2025
		add	dx, 0Ch
		mov	ah, 0D1h ; ''
		or	al, al
		jnz	short loc_279E
		mov	ah, 0D3h ; ''

loc_279E:				; CODE XREF: sub_278E+C.j
		mov	al, ah
		call	sub_2496
		xor	ax, ax
		retn
sub_278E	endp



; =============== S U B	R O U T	I N E =======================================


sub_2843	proc near		; CODE XREF: seg000:2A99.p sub_2AD5+8.p	...
		push	bx
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1
		cmp	cs:word_2028, 0
		jz	short loc_2867

		; sb dma active = stop
		call	sub_259E
		call	sub_273F
		mov	cs:byte_20A6, 0
		xor	ax, ax

loc_2867:				; CODE XREF: sub_2843+14.j
		pop	si
		pop	di
		pop	es
		pop	ds
		pop	bx
		retn
sub_2843	endp


; =============== S U B	R O U T	I N E =======================================


sub_286D	proc near		; CODE XREF: sub_2AF2+D.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1
		cmp	cs:word_2028, 1
		jnz	short loc_288D

		; sb dma active = set pause state
		call	sub_259E
		mov	cs:byte_20A6, 4
		xor	ax, ax

loc_288D:				; CODE XREF: sub_286D+13.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_286D	endp

; =============== S U B	R O U T	I N E =======================================


sub_27A6	proc near		; CODE XREF: sub_19B3+1D.p sub_19B3+34.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax


		cmp	cs:word_2028, 0
		jz	short loc_27BE

		; sb dma active = skip
		mov	ax, 1
		jmp	loc_283E
; ---------------------------------------------------------------------------

loc_27BE:				; CODE XREF: sub_27A6+10.j
		; start sb dma
		mov	cs:word_2028, 1

		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	cl, cs:byte_202C
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 40h	; '@'
		call	sub_2496
		mov	al, cl
		call	sub_2496
		mov	al, cs:byte_2027
		mov	dx, offset sb_irqHandler
		mov	bx, offset word_irqh
		call	sub_25EE
		mov	dx, cs:word_202D
		mov	ax, cs:word_202F
		call	sub_25DA
		mov	cs:byte_2459, dl
		mov	cs:word_245A, ax
		mov	cx, cs:word_2031
		mov	cs:word_245F, cx
		mov	cs:word_2461, 0
		add	ax, cs:word_2031
		adc	dl, 0
		sub	ax, 1
		sbb	dl, 0
		mov	cs:word_2463, ax
		sub	dl, cs:byte_2459
		mov	cs:byte_245E, dl
		call	sub_26CA
		mov	cs:byte_20A6, 2
		xor	ax, ax



loc_283E:				; CODE XREF: sub_27A6+15.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_27A6	endp

; =============== S U B	R O U T	I N E =======================================

sub_2892	proc near		; CODE XREF: sub_19B3+4D.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1


		cmp	cs:word_2028, 1
		jnz	short loc_28BC


		; restart pcm
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 0D4h ; ''
		call	sub_2496
		mov	cs:byte_20A6, 2
		xor	ax, ax

loc_28BC:				; CODE XREF: sub_2892+13.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_2892	endp

;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================


driver_end:

; free space
; - MT-32 = loc_8D5+


; ---------------------------------------------------------------------------

GetDeviceInfo:
		mov	ax, 1
		mov	cx, 20h	; ' '
		retn

; ---------------------------------------------------------------------------

InitDevice:
		call InitDevice_MT32

		call InitDevice_SB
		cmp ax,0
		jnz loc_InitDevice_fail


		; success = reclaim memory
		mov	cs:byte_20A7, 1
		mov ax,driver_end
		mov	bx, 2
		xor cx, cx

		jmp loc_InitDevice_done


loc_InitDevice_fail:
		mov ax,0FFFFh


loc_InitDevice_done:
		retn

; ---------------------------------------------------------------------------

InitDevice_MT32:
		mov	bx, cs:word_FC
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]
		xor	di, di

loc_82A:				; CODE XREF: seg000:0837j
		mov	bl, es:[si]
		mov	cs:[di+66h], bl
		inc	si
		inc	di
		cmp	di, 6Bh	; 'k'
		jb	short loc_82A
		mov	bx, 0FFh
		call	sub_291
		call	sub_6D8
		cmp	cs:word_102, 0FFFFh
		jnz	short loc_856
		mov	bx, 0D1h ; ''
		call	sub_7C9
		xor	cx, cx
		mov	ax, 0FFFFh
		retn
; ---------------------------------------------------------------------------

loc_856:				; CODE XREF: seg000:0848j
		mov	bl, 0B9h ; ''
		call	sub_291
		mov	bl, 98h	; ''
		call	sub_291
		mov	bl, 9Ah	; ''
		call	sub_291
		mov	bl, 9Ch	; ''
		call	sub_291
		mov	bl, 9Eh	; ''
		call	sub_291
		mov	bx, 0DFh ; ''
		call	sub_291
		xor	di, di

loc_877:				; CODE XREF: seg000:0883j
		mov	bl, cs:[di+53h]
		call	sub_2E6
		inc	di
		cmp	di, 0Bh
		jl	short loc_877
		call	sub_AA5
		mov	bx, 7Ah	; 'z'
		call	sub_7C9
		call	sub_AA5
		call	sub_8E3
		call	sub_AA5
		call	sub_969
		call	sub_AA5
		mov	bh, es:[si]
		inc	si
		mov	bl, es:[si]
		inc	si
		cmp	bx, 0ABCDh
		jnz	short loc_8B1
		call	sub_8E3
		call	sub_AA5

loc_8B1:				; CODE XREF: seg000:08A9j
		mov	bx, 66h	; 'f'
		call	sub_7C9
		xor	dx, dx
		mov	ax, cs:word_A2
		mov	bx, 0Fh
		div	bx
		mov	cs:word_100, ax
		mov	cs:word_F4, 0
		mov	cs:byte_EF, 0FFh
		mov	bx, 2
		mov	word ptr cs:[bx+104h], ShutdownDevice
		mov	ax, driver_end
		xor	cx, cx
		retn

; =============== S U B	R O U T	I N E =======================================


InitDevice_SB:
sub_275E	proc near		; CODE XREF: seg000:2BF7.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		call	sub_24B7
		jnz	short loc_2783
		call	sub_24E4
		jnz	short loc_2783
		call	sub_257A
		jnz	short loc_2783
		call	sub_250D
		jnz	short loc_2783

		mov	al, 1
		call	sub_278E


		; setup sb dac volume
		mov cs:byte_sbvol, 13
		call SetVolume_SB


		xor	ax, ax

loc_2783:				; CODE XREF: sub_275E+D.j sub_275E+12.j	...
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_275E	endp



; =============== S U B	R O U T	I N E =======================================


sub_8E3		proc near		; CODE XREF: seg000:0891p seg000:08ABp
		push	dx
		push	di
		xor	dx, dx

loc_8E7:				; CODE XREF: sub_8E3+81j
		push	bx
		mov	bx, 0DFh ; ''
		call	sub_291
		mov	cs:byte_E5, 0
		xor	di, di

loc_8F6:				; CODE XREF: sub_8E3+1Fj
		mov	bl, cs:[di+4Bh]
		call	sub_2E6
		inc	di
		cmp	di, 5
		jl	short loc_8F6

loc_904:				; CODE XREF: sub_8E3+32j
		mov	bl, cs:[di+4Bh]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_904
		pop	bx
		xor	di, di

loc_91A:				; CODE XREF: sub_8E3+48j
		mov	bl, es:[si]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	dx
		inc	si
		inc	di
		cmp	di, 8
		jl	short loc_91A
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		add	cs:byte_52, 8
		cmp	cs:byte_52, 7Fh	; ''
		jbe	short loc_95E
		inc	cs:byte_51
		sub	cs:byte_52, 80h	; ''

loc_95E:				; CODE XREF: sub_8E3+6Ej
		cmp	dx, 180h
		jnb	short loc_966
		jmp	short loc_8E7
; ---------------------------------------------------------------------------

loc_966:				; CODE XREF: sub_8E3+7Fj
		pop	di
		pop	dx
		retn
sub_8E3		endp


; =============== S U B	R O U T	I N E =======================================


sub_969		proc near		; CODE XREF: seg000:0897p
		push	cx
		push	dx
		push	di
		mov	dl, es:[si]
		inc	si
		cmp	dl, 0
		jz	short loc_9B7
		xor	cl, cl
		mov	cs:byte_49, 0
		mov	cs:byte_4A, 0

loc_983:				; CODE XREF: sub_969+4Cj
		call	sub_9BB
		call	sub_AA5
		call	sub_A30
		call	sub_AA5
		call	sub_A30
		call	sub_AA5
		call	sub_A30
		call	sub_AA5
		call	sub_A30
		call	sub_AA5
		inc	cl
		inc	cl
		mov	cs:byte_49, cl
		mov	cs:byte_4A, 0
		dec	dl
		cmp	dl, 0
		ja	short loc_983

loc_9B7:				; CODE XREF: sub_969+Aj
		pop	di
		pop	dx
		pop	cx
		retn
sub_969		endp


; =============== S U B	R O U T	I N E =======================================


sub_9BB		proc near		; CODE XREF: sub_969:loc_983p
		mov	bx, 0DFh ; ''
		call	sub_291
		mov	cs:byte_E5, 0
		xor	di, di

loc_9C9:				; CODE XREF: sub_9BB+1Aj
		mov	bl, cs:[di+43h]
		call	sub_2E6
		inc	di
		cmp	di, 5
		jl	short loc_9C9

loc_9D7:				; CODE XREF: sub_9BB+2Dj
		mov	bl, cs:[di+43h]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_9D7
		xor	di, di

loc_9EC:				; CODE XREF: sub_9BB+41j
		mov	bl, es:[si]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	si
		inc	di
		cmp	di, 0Eh
		jl	short loc_9EC
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		add	cs:byte_4A, 0Eh
		cmp	cs:byte_4A, 7Fh	; ''
		jbe	short locret_A2F
		inc	cs:byte_49
		sub	cs:byte_4A, 80h	; ''

locret_A2F:				; CODE XREF: sub_9BB+67j
		retn
sub_9BB		endp


; =============== S U B	R O U T	I N E =======================================


sub_A30		proc near		; CODE XREF: sub_969+20p sub_969+26p ...
		mov	bx, 0DFh ; ''
		call	sub_291
		mov	cs:byte_E5, 0
		xor	di, di

loc_A3E:				; CODE XREF: sub_A30+1Aj
		mov	bl, cs:[di+43h]
		call	sub_2E6
		inc	di
		cmp	di, 5
		jl	short loc_A3E

loc_A4C:				; CODE XREF: sub_A30+2Dj
		mov	bl, cs:[di+43h]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	di
		cmp	di, 8
		jl	short loc_A4C
		xor	di, di

loc_A61:				; CODE XREF: sub_A30+41j
		mov	bl, es:[si]
		add	cs:byte_E5, bl
		call	sub_2E6
		inc	si
		inc	di
		cmp	di, 3Ah	; ':'
		jl	short loc_A61
		neg	cs:byte_E5
		and	cs:byte_E5, 7Fh
		mov	bl, cs:byte_E5
		call	sub_2E6
		mov	bl, 0F7h ; ''
		call	sub_2E6
		add	cs:byte_4A, 3Ah	; ':'
		cmp	cs:byte_4A, 7Fh	; ''
		jbe	short locret_AA4
		inc	cs:byte_49
		sub	cs:byte_4A, 80h	; ''

locret_AA4:				; CODE XREF: sub_A30+67j
		retn
sub_A30		endp


; =============== S U B	R O U T	I N E =======================================


sub_AA5		proc near		; CODE XREF: seg000:0885p seg000:088Ep ...
		push	di
		xor	di, di

loc_AA8:				; CODE XREF: sub_AA5+7j
		inc	di
		cmp	di, 0FFFFh
		jb	short loc_AA8
		pop	di
		retn
sub_AA5		endp


; =============== S U B	R O U T	I N E =======================================


sub_2465	proc near		; CODE XREF: sub_24E4+D.p sub_24E4+14.p
		mov	cx, 200h
		mov	ah, al

loc_246A:				; CODE XREF: sub_2465+A.j
		in	al, dx
		or	al, al
		jns	short loc_2474
		loop	loc_246A
		stc
		jmp	short locret_2478
; ---------------------------------------------------------------------------

loc_2474:				; CODE XREF: sub_2465+8.j
		mov	al, ah
		out	dx, al
		clc

locret_2478:				; CODE XREF: sub_2465+D.j
		retn
sub_2465	endp


; =============== S U B	R O U T	I N E =======================================


sub_2479	proc near		; CODE XREF: sub_24B7:loc_24CF.p
					; sub_24E4+19.p
		push	dx
		mov	dx, cs:word_2025
		add	dl, 0Eh
		mov	cx, 200h

loc_2485:				; CODE XREF: sub_2479+11.j
		in	al, dx
		or	al, al
		js	short loc_248F
		loop	loc_2485
		stc
		jmp	short loc_2494
; ---------------------------------------------------------------------------

loc_248F:				; CODE XREF: sub_2479+F.j
		sub	dl, 4
		in	al, dx
		clc

loc_2494:				; CODE XREF: sub_2479+14.j
		pop	dx
		retn
sub_2479	endp



; ---------------------------------------------------------------------------

sb_irq2:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 2
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq3:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 3
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq5:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 5
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq7:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 7
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret

; =============== S U B	R O U T	I N E =======================================


sub_24A1	proc near		; CODE XREF: sub_257A+D.p sub_257A+12.p
		push	dx
		mov	dx, cs:word_2025
		add	dl, 0Eh
		xor	al, al

loc_24AC:				; CODE XREF: sub_24A1+E.j
		in	al, dx
		or	al, al
		jns	short loc_24AC
		sub	dl, 4
		in	al, dx
		pop	dx
		retn
sub_24A1	endp


; =============== S U B	R O U T	I N E =======================================

sub_24B7	proc near		; CODE XREF: sub_275E+A.p
		mov	dx, cs:word_2025
		add	dl, 6
		mov	al, 1
		out	dx, al
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		xor	al, al
		out	dx, al
		mov	cl, 20h	; ' '

loc_24CF:				; CODE XREF: sub_24B7+21.j
		call	sub_2479
		cmp	al, 0AAh ; ''
		jz	short loc_24DF
		dec	cl
		jnz	short loc_24CF
		mov	ax, 2
		jmp	short loc_24E1
; ---------------------------------------------------------------------------

loc_24DF:				; CODE XREF: sub_24B7+1D.j
		xor	ax, ax

loc_24E1:				; CODE XREF: sub_24B7+26.j
		or	ax, ax
		retn
sub_24B7	endp


; =============== S U B	R O U T	I N E =======================================


sub_24E4	proc near		; CODE XREF: sub_275E+F.p
		mov	bx, 2
		mov	al, 0E0h ; ''
		mov	dx, cs:word_2025
		add	dx, 0Ch
		call	sub_2465
		jb	short loc_2508
		mov	al, 0AAh ; ''
		call	sub_2465
		jb	short loc_2508
		call	sub_2479
		jb	short loc_2508
		cmp	al, 55h	; 'U'
		jnz	short loc_2508
		xor	bx, bx

loc_2508:				; CODE XREF: sub_24E4+10.j sub_24E4+17.j ...
		mov	ax, bx
		or	ax, ax
		retn
sub_24E4	endp


; =============== S U B	R O U T	I N E =======================================

sub_250D	proc near		; CODE XREF: sub_275E+19.p
		; save IRQs
		mov	al, 2
		mov	dx, offset sb_irq2
		mov	bx, offset word_irq2
		call	sub_25EE

		mov	al, 3
		mov	dx, offset sb_irq3
		mov	bx, offset word_irq3
		call	sub_25EE

		mov	al, 5
		mov	dx, offset sb_irq5
		mov	bx, offset word_irq5
		call	sub_25EE

		mov	al, 7
		mov	dx, offset sb_irq7
		mov	bx, offset word_irq7
		call	sub_25EE

		mov	dx, cs
		mov	ax, offset sub_250D
		call	sub_25DA

		xor	cx, cx
		mov	dh, 49h	; 'I'
		call	sub_25B1
		mov	dx, cs:word_2025
		add	dx, 0Ch
		mov	al, 40h	; '@'
		call	sub_2496
		mov	al, 64h	; 'd'
		call	sub_2496
		mov	al, 14h
		call	sub_2496
		xor	al, al
		call	sub_2496
		xor	al, al
		call	sub_2496
		xor	ax, ax
		mov	cx, 200h

loc_2558:				; CODE XREF: sub_250D+53.j
		; fast cpu hack
		hlt

		cmp	cs:byte_2027, 0
		jnz	short loc_2565
		loop	loc_2558
		mov	ax, 3

loc_2565:				; CODE XREF: sub_250D+51.j
		push	ax

		; restore IRQs
		mov	al, 2
		mov	bx, offset word_irq2
		call	sub_2629

		mov	al, 3
		mov	bx, offset word_irq3
		call	sub_2629

		mov	al, 5
		mov	bx, offset word_irq5
		call	sub_2629

		mov	al, 7
		mov	bx, offset word_irq7
		call	sub_2629

		pop	ax
		or	ax, ax
		retn
sub_250D	endp


; =============== S U B	R O U T	I N E =======================================


sub_257A	proc near		; CODE XREF: sub_275E+14.p
		mov	al, 0E1h ; ''
		mov	dx, cs:word_2025
		add	dl, 0Ch
		call	sub_2496
		call	sub_24A1
		mov	ah, al
		call	sub_24A1
		mov	bx, 1
		cmp	ax, 101h
		jb	short loc_2599
		xor	bx, bx

loc_2599:				; CODE XREF: sub_257A+1B.j
		mov	ax, bx
		or	ax, ax
		retn
sub_257A	endp



seg000		ends


		end
